/* All the preliminaries */
CREATE DATABASE batts;
USE batts;
grant ALL on batts.* TO batts@localhost IDENTIFIED BY "gimmeanewpassword";

/* Create all of our tables... should be self-explanatory */
CREATE TABLE customers
(
	customer_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	username VARCHAR(16) NOT NULL,
	fullname VARCHAR(48)
);

CREATE TABLE people
(
	person_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	username VARCHAR(16) NOT NULL,
	fullname VARCHAR(48),
	email VARCHAR(255) NOT NULL,
	customer INT UNSIGNED
);

CREATE TABLE categories
(
	category_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(31) NOT NULL
);

CREATE TABLE priorities
(
	priority_id INT UNSIGNED NOT NULL PRIMARY KEY,
	name VARCHAR(31) NOT NULL
);

CREATE TABLE billing_codes
(
	billable_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(31) NOT NULL
);

CREATE TABLE resolutions
(
	resolution_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(31) NOT NULL
);

CREATE TABLE tickets
(
	ticket_id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	creator	INT UNSIGNED NOT NULL,
	requestor INT UNSIGNED NOT NULL DEFAULT 1,
	customer INT UNSIGNED NOT NULL,
	category INT UNSIGNED NOT NULL,
	priority INT UNSIGNED NOT NULL,
	lastmodified TIMESTAMP NOT NULL,
	creationtime TIMESTAMP NOT NULL,
	assignedto INT UNSIGNED,
	shortdesc VARCHAR(255),
	longdesc LONGTEXT,
	refticket INT UNSIGNED,
	resolution INT UNSIGNED NOT NULL,
	restext LONGTEXT
);

CREATE TABLE events
(
	event_ID INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	ticket INT UNSIGNED NOT NULL,
	person INT UNSIGNED NOT NULL,
	billable INT UNSIGNED NOT NULL,
	endtime TIMESTAMP,
	starttime TIMESTAMP,
	logmessage LONGTEXT,
	private enum("Y","N") NOT NULL DEFAULT "Y"
);

/* Set up any indexes now --- we can do it as part of the tables, I
   suppose, but we haven't right now. */
ALTER TABLE people ADD UNIQUE (username);
ALTER TABLE customers ADD UNIQUE (username);

/* Populate the tables from files */

LOAD DATA LOCAL INFILE "categories.txt" INTO TABLE categories;
LOAD DATA LOCAL INFILE "billing_codes.txt" INTO TABLE billing_codes;
LOAD DATA LOCAL INFILE "priorities.txt" INTO TABLE priorities;
LOAD DATA LOCAL INFILE "resolutions.txt" INTO TABLE resolutions;
LOAD DATA LOCAL INFILE "customers.txt" INTO TABLE customers;
LOAD DATA LOCAL INFILE "people.txt" INTO TABLE people;

/* This adds in a sample ticket, just for testing purposes. */
INSERT INTO tickets VALUES(
	NULL, 1, NULL, 1, 1, 1, NOW(), NOW(), 2, "Our First Ticket",
	"This ticket has been entered to test the system.", NULL, 3,
	NULL);
